SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE FUNCTION [dbo].[SF_BancoPatagonia_Proveedores_Padron_TX](@pId_Proveedor INT) 
RETURNS CHAR(870)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo*/
DECLARE @Retorno						CHAR(870)

/*--------------------------------------------------------------------------------------------------------------------------------*/

DECLARE @aRegistroId					CHAR(2)		/*Constante 'PB'*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Identificacion del Beneficiario y Tipo de Actualizacion*/
DECLARE @aIBNumeroBen					CHAR(25)		/*Ajustado a izquierda.Es mandatario para todos los casos.*/

DECLARE @aIBTipoActualizacion			CHAR(3)			/*'BAJ'  Se considerar baja de Beneficiario en el Banco. 
														Cualquier otro valor implica actualizacin o alta de registro, siempre en forma completa;
														por lo tanto, se debern informar todos los campos.*/

DECLARE @aIBNombreBen					CHAR(60)		/*Mandatario si no es una baja.*/

DECLARE @aIBTipoDocumentoBene			CHAR(3)			/*Mandatario si no es una baja. Valores nicos y posibles	001 = DNI	002 = LE
														003 = LC	004 = CI	010 = CUIL (*)	011 = CUIT (*)	014 = CDI (*)	040 = PSPT
														(*) nicos documentos vlidos para transferencias internas y a otros Bancos*/

DECLARE @aIBNroCuit_cuilBen				CHAR(11)		/*Mandatario si no es una baja.		Nro. dado por la AFIP*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Domicilio, Telefono, Fax y Mail del Beneficiario*/
DECLARE @aDatosDomicilioBen				CHAR(120)		/*Opcional*/

DECLARE @aDatosCodigoPostalBen			CHAR(15)		/*Opcional	Ajustado a izquierda*/

DECLARE @aDatosTelefonoBen				CHAR(25)		/*Ejemplo: 054-0011-4651-4444(333) 
														Pas: 3 + Cdad: 4 + Ctral: 4 + Abonado: 4 + Interno: 4*/

DECLARE @aDatosFaxBen					CHAR(25)		/*Idem Telefono*/

DECLARE @aDatosEmailBen					CHAR(70)		/*Mandatario si se solicita aviso de pago por EMAIL. Si se necesita dar aviso a ms de una
														casilla, se recomendar al Beneficiario la creacin de un grupo bajo una misma direccin*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Datos de Validacion para permitir pagos*/
DECLARE @aDVMarcaBloqueoPago			CHAR(3)			/*      No aplica	BLQ  Bloquear	DES  Desbloquear
														Ordena al Banco, inhibir prximos pagos a este Beneficiario, o rehabilitarlo en el servicio.*/

DECLARE @aDVMontoMaxPes					CHAR(15)		/*Long=15.2 
														Importe mximo en pesos, sobre el cual una orden recibida ser rechazada.
														No dejar en ceros, para permitir cualquier monto ingresar 99999999999999*/

DECLARE @aDVMontoMaxDol					CHAR(15)		/*Long=15.2
														Importe mximo en dlares, sobre el cual una orden recibida ser rechazada. 
														No dejar en ceros, para permitir cualquier monto ingresar 99999999999999*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Especificaciones de avisos y comunicaciones al beneficiario*/
DECLARE @aECRestriccionAvisosBen		CHAR(3)			/*Dejar en blanco ya que esto se informa en cada pago*/

DECLARE @aECMedioComunicacionBen		CHAR(3)			/*Es el medio elegido para el envo automtico de avisos de pago. Debe ser:
														EML  Se enviarn e-mail de avisos a la direccin indicada ms arriba . (default)
														         No se enviarn avisos*/

DECLARE @aECNombrePersonaContactoBen	CHAR(60)		/**/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Datos para la ejecucion de pagos con cheques*/
DECLARE @aEPCInsertClausulaNOEmitirChe	CHAR(1)			/*'S' - Si (es el valor por omisin)	'N' - No se imprime dicha clusula. OK*/

DECLARE @aEPCNroDoc1erAutorizadoRetirar	CHAR(22)		/*Tipo de documento + nmero como string.	p.e.: 'D.N.I. 23.789.987'
														Indicar autorizados slo si no requiere recibo oficial del Beneficiario */

DECLARE @aEPCNombre1erAutorizadoRetirar	CHAR(60)		/**/

DECLARE @aEPCTipo1erAutorizado			CHAR(3)			/*Indica si la persona anteriormente informada se encuentra autorizada al retiro de:
														CHE  Pagos con cheques	EFE  Pagos en efectivo	
														CYE  Pagos con cheques o efectivo	
														En todos los casos, est persona se considera autorizada a retirar los comprobantes 
														adjuntos en cualquier tipo de pago.*/

DECLARE @aEPCNroDoc2doAutorizadoRetirar	CHAR(22)		/*Tipo de documento + nmero como string.	p.e.: 'D.N.I. 23.789.987'*/

DECLARE @aEPCNombre2doAutorizadoRetirar	CHAR(60)		/**/

DECLARE @aEPCTipo2doAutorizado			CHAR(3)			/*dem autorizado 1.*/

DECLARE @aEPCNroDoc3erAutorizadoRetiro	CHAR(22)		/*Tipo de documento + nmero como string.	p.e.: 'D.N.I. 23.789.987'*/

DECLARE @aEPCNombre3erAutorizadoRetirar	CHAR(60)		/**/

DECLARE @aEPCTipo3erAutorizado			CHAR(3)			/*dem autorizado 1.*/

DECLARE @aRequerirReciboBenCheque		CHAR(1)			/*S- Si(para la entrega del cheque se requerir recibo membreteado del Beneficiario 
															 valor por omisin)	'N'  No (no se requiere el recibo membreteado)*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Canales de envios de pagos con cheque*/
DECLARE @aCEPCTipoRutaElegidaDefault	CHAR(3)			/*Constante:'BCO'  (valor por omisin.)  Se enviar a la sucursal del Banco, 
														elegida por default en el campo siguiente.*/

DECLARE @aCEPCSucursalBancoEnvioChe		CHAR(5)			/*Sucursal del Banco, por omisin, elegida para girar pagos con cheques.
														Se espera recibir 3 dgitos numricos ajustados a izquierda.*/

DECLARE @aCEPCEspacioBlanco				CHAR(8)			/*Actualmente:Filler	Ajustado a izquierda.*/

DECLARE @aCEPCCeros						CHAR(5)			/*Actualmente:Filler*/

/*--------------------------------------------------------------------------------------------------------------------------------*/

/*Datos de cuentas creditos para pagos electronicos por default*/
DECLARE @aDCtaECBUBenAcreditarBtoB		CHAR(22)		/*Cuenta a acreditar para pagos electrnicos dentro del mismo Banco (Book to Book).*/

DECLARE @aDCtaESistemaAcreditarBtoB		CHAR(2)			/*'CC' - cuenta corriente	'CA' - caja de ahorro*/

DECLARE @aDCtaEMonedaCtaAcreditarBtoB	CHAR(3)			/*'ARS'  pesos */

DECLARE @aDCtaECBUBenAcreditarOtroB		CHAR(22)		/*Cuenta a acreditar para pagos electrnicos en otro Banco (MEP,SNP,e- settlement).*/

DECLARE @aDCtaESistemaAcreditarOtroB	CHAR(2)			/*'CC' - cuenta corriente	'CA' - caja de ahorro*/

DECLARE @aDCtaEMonedaCtaAcreditarOtroB	CHAR(3)			/*'ARS'  pesos*/

DECLARE @aDCtaEEspacioBlanco			CHAR(80)		/*Filler*/

/*FIN Variables del Archivo*/

/*Declaracion Variables Locales*/
DECLARE @Id_Cta_Banco		SMALLINT
/*FIN Declaracion Variables Locales*/
/*================================================================================================================================*/

SET @Id_Cta_Banco = (SELECT Id_Cta_Banco FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)

SET @aRegistroId						= 'PB'

/*Identificacion del Beneficiario y Tipo de Actualizacion*/
SET @aIBNumeroBen						= (SELECT LEFT(CAST(Id_Proveedor AS VARCHAR) + '                         ', 25) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aIBTipoActualizacion				= 'ALT'
SET @aIBNombreBen						= (SELECT LEFT(ISNULL(Razon_Social, '') + '                                                            ', 60) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aIBTipoDocumentoBene				= '011' /*CUIT*/
SET @aIBNroCuit_cuilBen					= (SELECT LEFT(CAST(ISNULL(Cuit, '') AS VARCHAR) + '           ', 11) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)

/*Domicilio, Telefono, Fax y Mail del Beneficiario*/
SET @aDatosDomicilioBen					= (SELECT LEFT(CAST(ISNULL(Direccion, '') AS VARCHAR) + '                                                                                                                        ', 120) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDatosCodigoPostalBen				= (SELECT LEFT(CAST(ISNULL(Cp, '') AS VARCHAR) + '               ', 15) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDatosTelefonoBen					= (SELECT LEFT(CAST(ISNULL(Telefono, '') AS VARCHAR) + '                         ', 25) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDatosFaxBen						= (SELECT LEFT(CAST(ISNULL(Fax, '') AS VARCHAR(25)) + '                         ', 25) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDatosEmailBen						= (SELECT LEFT(CAST(ISNULL(Email, '') AS VARCHAR(70)) + '                                                                      ', 70) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)

/*Datos de Validacion para permitir pagos*/
SET @aDVMarcaBloqueoPago				= '   '
SET @aDVMontoMaxPes						= '000000010000000'
SET @aDVMontoMaxDol						= '000000000000000'

/*Especificaciones de avisos y comunicaciones al beneficiario*/
SET @aECRestriccionAvisosBen			= '   '
SET @aECMedioComunicacionBen			= 'EML'
SET @aECNombrePersonaContactoBen		= (SELECT LEFT(ISNULL(Razon_Social, '') + '                                                            ', 60) FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)

/*Datos para la ejecucion de pagos con cheques*/
SET @aEPCInsertClausulaNOEmitirChe		= 'N'
SET @aEPCNroDoc1erAutorizadoRetirar		= '                      '
SET @aEPCNombre1erAutorizadoRetirar		= '                                                            '
SET @aEPCTipo1erAutorizado				= '   '
SET @aEPCNroDoc2doAutorizadoRetirar		= '                      '
SET @aEPCNombre2doAutorizadoRetirar		= '                                                            '
SET @aEPCTipo2doAutorizado				= '   '
SET @aEPCNroDoc3erAutorizadoRetiro		= '                      '
SET @aEPCNombre3erAutorizadoRetirar		= '                                                            '
SET @aEPCTipo3erAutorizado				= '   '
SET @aRequerirReciboBenCheque			= 'N'

/*Canales de envios de pagos con cheque*/
SET @aCEPCTipoRutaElegidaDefault		= 'BCO'
SET @aCEPCSucursalBancoEnvioChe			= (SELECT RIGHT('000' + CAST(Sucursal AS VARCHAR), 3) FROM Bancos_Ctas WHERE Id_Cta_Banco = @Id_Cta_Banco)
SET @aCEPCEspacioBlanco					= '        '
SET @aCEPCCeros							= '00000'

/*Datos de cuentas creditos para pagos electronicos por default*/
SET @aDCtaECBUBenAcreditarBtoB			= (SELECT ISNULL(CBU, '') FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDCtaESistemaAcreditarBtoB			= 'CC'
SET @aDCtaEMonedaCtaAcreditarBtoB		= 'ARS'
SET @aDCtaECBUBenAcreditarOtroB			= (SELECT ISNULL(CBU, '') FROM Proveedores WHERE Id_Proveedor = @pId_Proveedor)
SET @aDCtaESistemaAcreditarOtroB		= 'CC'
SET @aDCtaEMonedaCtaAcreditarOtroB		= 'ARS'
SET @aDCtaEEspacioBlanco				= '                                                                                '



SET @Retorno =	@aRegistroId					+ @aIBNumeroBen						+ @aIBTipoActualizacion +
				@aIBNombreBen					+ @aIBTipoDocumentoBene				+ @aIBNroCuit_cuilBen +
				@aDatosDomicilioBen				+ @aDatosCodigoPostalBen			+ @aDatosTelefonoBen +
				@aDatosFaxBen					+ @aDatosEmailBen					+ @aDVMarcaBloqueoPago +
				@aDVMontoMaxPes					+ @aDVMontoMaxDol					+ @aECRestriccionAvisosBen +
				@aECMedioComunicacionBen		+ @aECNombrePersonaContactoBen		+ @aEPCInsertClausulaNOEmitirChe +
				@aEPCNroDoc1erAutorizadoRetirar + @aEPCNombre1erAutorizadoRetirar	+ @aEPCTipo1erAutorizado +
				@aEPCNroDoc2doAutorizadoRetirar + @aEPCNombre2doAutorizadoRetirar	+ @aEPCTipo2doAutorizado +
				@aEPCNroDoc3erAutorizadoRetiro	+ @aEPCNombre3erAutorizadoRetirar	+ @aEPCTipo3erAutorizado +
				@aRequerirReciboBenCheque		+ @aCEPCTipoRutaElegidaDefault		+ @aCEPCSucursalBancoEnvioChe +
				@aCEPCEspacioBlanco				+ @aCEPCCeros						+ @aDCtaECBUBenAcreditarBtoB +
				@aDCtaESistemaAcreditarBtoB		+ @aDCtaEMonedaCtaAcreditarBtoB		+ @aDCtaECBUBenAcreditarOtroB + 
				@aDCtaESistemaAcreditarOtroB	+ @aDCtaEMonedaCtaAcreditarOtroB	+ @aDCtaEEspacioBlanco
				
RETURN @Retorno
END				